//
//  ContentView.swift
//  Demo App Clip
//
//  Created by Gero Gerber on 01.11.20.
//

import StoreKit
import SwiftUI

struct ContentView: View {

    @EnvironmentObject var model: AppClipModel

    @State private var showOverlay = false

    var body: some View {
        VStack {
            Text("Inside Region: \(model.isInsideRegion ? "true" : "false")")
                .padding()
            Text("Region Error: \(model.regionError ?? "")")
                .padding()
            Text("Path: \(model.path ?? "none")")
                .padding()
            ForEach(model.queryItems ?? [], id: \.self) { queryItem in
                Text("Query Item - Name: '\(queryItem.name)' Value: '\(queryItem.value ?? "")'")
                    .padding()
            }

            Button("Show Overlay") {
                self.showOverlay.toggle()
            }
            .appStoreOverlay(isPresented: $showOverlay) {
                SKOverlay.AppClipConfiguration(position: .bottom)
            }

            #if IS_APP_CLIP

                // Wird nur ausgeführt, wenn in den Build Settings IS_APP_CLIP definiert ist

            #else

            // Wird nur ausgeführt, wenn in den Build Settings nicht(!) IS_APP_CLIP definiert ist

            #endif
        }
    }
}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
}
